import { useRouter } from 'next/router';
import { ChatKit, useChatKit } from '@openai/chatkit-react';
import Head from 'next/head';

export default function ChatPage() {
    const router = useRouter();
    const { clientId } = router.query;

    const { control } = useChatKit({
        api: {
            async getClientSecret() {
                if (!clientId) return '';

                const res = await fetch('/api/chatkit/session', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ clientId }),
                });

                if (!res.ok) {
                    throw new Error('Failed to create session');
                }

                const { client_secret } = await res.json();
                return client_secret;
            },
        },
    });

    if (!clientId) {
        return <div>Loading...</div>;
    }

    return (
        <div className="h-screen w-screen bg-white">
            <Head>
                <title>Chat</title>
                <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
            </Head>
            <ChatKit
                control={control}
                className="h-full w-full"
            // You can customize the appearance here
            />
        </div>
    );
}
